(function(global){
  function uid(){ try{ return crypto.randomUUID(); }catch(_){ return Date.now()+'_'+Math.random().toString(16).slice(2);} }
  function createRtoClient(opts){
    opts = opts || {};
    var timeoutMs = opts.timeoutMs || 12000;
    var eventFilter = opts.eventFilter || function(){ return true; };
    var target = opts.target || global;
    var listeners = new Set();

    function send(payload){
      var requestId = payload.requestId || uid();
      var env = Object.assign({}, payload, { requestId: requestId });
      return new Promise(function(resolve, reject){
        var to = setTimeout(function(){
          var e = new Error('RTO timeout for '+payload.type);
          e.code='TIMEOUT'; reject(e);
        }, timeoutMs);
        function onMsg(ev){
          if (!eventFilter(ev)) return;
          var d = ev.data || {};
          if (d.origin==='plugin' && d.type==='tabStatus'){ listeners.forEach(function(fn){ try{fn(d);}catch(e){} }); }
          if (d.requestId !== requestId) return;
          if (d.type==='RTO_RESPONSE'){
            clearTimeout(to); global.removeEventListener('message', onMsg);
            if (d.ok===false || d.error){ var er=new Error((d.error&&d.error.message)||'RTO error'); er.code=(d.error&&d.error.code)||'ERR'; reject(er); }
            else resolve(d.data);
          } else if (d.type==='getHtmlResult'){
            clearTimeout(to); global.removeEventListener('message', onMsg);
            if (d.status==='error'){ var e2=new Error('ELEMENT_NOT_FOUND'); e2.code='ELEMENT_NOT_FOUND'; reject(e2); }
            else resolve(d.data);
          }
        }
        global.addEventListener('message', onMsg);
        target.postMessage(env, '*');
      });
    }

    return {
      onTabStatus: function(cb){ listeners.add(cb); return function(){ listeners.delete(cb); }; },
      detect: function(){ return send({ origin:'admin-page', type:'RTO_REQUEST', action:'detect' }); },
      open: function(p){ return send(Object.assign({origin:'admin-page',type:'open'}, p)); },
      navigate: function(p){ return send(Object.assign({origin:'admin-page',type:'navigate'}, p)); },
      focus: function(tabKey){ return send({ origin:'admin-page', type:'focus', tabKey: tabKey }); },
      close: function(tabKey){ return send({ origin:'admin-page', type:'close', tabKey: tabKey }); },
      domType: function(p){ return send(Object.assign({origin:'admin-page',type:'domType'}, p)); },
      domClick: function(p){ return send(Object.assign({origin:'admin-page',type:'domClick'}, p)); },
      submit: function(p){ return send(Object.assign({origin:'admin-page',type:'submit'}, p)); },
      highlight: function(p){ return send(Object.assign({origin:'admin-page',type:'highlight'}, p)); },
      runJs: function(p){ return send(Object.assign({origin:'admin-page',type:'runJs'}, p)); },
      getHtml: function(p){ return send({ origin:'admin-page', type:'command', action:'getHtml', tabKey:p.tabKey, payload:{ selector:p.selector, property:p.property||'outerHTML' } }); },
      listTabs: function(){ return send({ origin:'admin-page', type:'listTabs' }); }
    };
  }

  global.RTO_SDK = { createRtoClient: createRtoClient };
})(window);
