export function createRtoClient(opts = {}){
  const timeoutMs = opts.timeoutMs ?? 12000;
  const eventFilter = opts.eventFilter ?? (()=>true);
  const target = opts.target ?? window;
  const listeners = new Set();
  function uid(){ try{ return crypto.randomUUID(); }catch(_){ return Date.now()+'_'+Math.random().toString(16).slice(2);} }
  function send(payload){
    const requestId = payload.requestId || uid();
    const env = { ...payload, requestId };
    return new Promise((resolve,reject)=>{
      const to = setTimeout(()=>{ const e=new Error('RTO timeout for '+payload.type); e.code='TIMEOUT'; reject(e); }, timeoutMs);
      function onMsg(ev){
        if (!eventFilter(ev)) return;
        const d = ev.data || {};
        if (d.origin==='plugin' && d.type==='tabStatus'){ listeners.forEach(fn=>{ try{fn(d);}catch{} }); }
        if (d.requestId !== requestId) return;
        if (d.type==='RTO_RESPONSE'){ clearTimeout(to); window.removeEventListener('message', onMsg); return (d.ok===false||d.error)? reject(Object.assign(new Error(d.error?.message||'RTO error'),{code:d.error?.code||'ERR'})) : resolve(d.data); }
        if (d.type==='getHtmlResult'){ clearTimeout(to); window.removeEventListener('message', onMsg); return d.status==='error'? reject(Object.assign(new Error('ELEMENT_NOT_FOUND'),{code:'ELEMENT_NOT_FOUND'})) : resolve(d.data); }
      }
      window.addEventListener('message', onMsg);
      target.postMessage(env, '*');
    });
  }
  return {
    onTabStatus: (cb)=>{ listeners.add(cb); return ()=>listeners.delete(cb); },
    detect: ()=>send({ origin:'admin-page', type:'RTO_REQUEST', action:'detect' }),
    open: (p)=>send({ origin:'admin-page', type:'open', ...p }),
    navigate: (p)=>send({ origin:'admin-page', type:'navigate', ...p }),
    focus: (tabKey)=>send({ origin:'admin-page', type:'focus', tabKey }),
    close: (tabKey)=>send({ origin:'admin-page', type:'close', tabKey }),
    domType: (p)=>send({ origin:'admin-page', type:'domType', ...p }),
    domClick: (p)=>send({ origin:'admin-page', type:'domClick', ...p }),
    submit: (p)=>send({ origin:'admin-page', type:'submit', ...p }),
    highlight: (p)=>send({ origin:'admin-page', type:'highlight', ...p }),
    runJs: (p)=>send({ origin:'admin-page', type:'runJs', ...p }),
    getHtml: (p)=>send({ origin:'admin-page', type:'command', action:'getHtml', tabKey:p.tabKey, payload:{ selector:p.selector, property:p.property||'outerHTML' } }),
    listTabs: ()=>send({ origin:'admin-page', type:'listTabs' })
  };
}
