import { describe, it, expect } from 'vitest';
import { z } from 'zod';
import { DetectRequest, RtoResponse, GetHtmlRequest } from '../src/schemas';

describe('Contract schemas', () => {
  it('DetectRequest should validate minimal detect', () => {
    const sample = { origin:'admin-page', type:'RTO_REQUEST', action:'detect' };
    expect(() => DetectRequest.parse(sample)).not.toThrow();
  });

  it('GetHtmlRequest should validate sample', () => {
    const sample = { origin:'admin-page', type:'command', action:'getHtml', tabKey:'google', payload:{ selector:'#a' }, requestId:'1' };
    expect(() => GetHtmlRequest.parse(sample)).not.toThrow();
  });

  it('RtoResponse should accept ok or error', () => {
    const ok = { type:'RTO_RESPONSE', ok:true, data:{ ready:true } };
    const err = { type:'RTO_RESPONSE', ok:false, error:{ code:'TIMEOUT', message:'took too long' } };
    expect(() => RtoResponse.parse(ok)).not.toThrow();
    expect(() => RtoResponse.parse(err)).not.toThrow();
  });
});
