# @rto/sdk (v7.10.1)

Remote Tab Opener (RTO) — SDK to control browser tabs from a web page via `window.postMessage`.

- Typed client (`RtoClient`) for: `detect`, `open`, `focus`, `navigate`, `close`, DOM actions (`domClick`, `domType`, `submit`, `highlight`, `getHtml`), `runJs`, `listTabs`, and event `onTabStatus`.
- Promise-based, timeouts, request/response correlation.
- **MV2 → MV3**: SDK is protocol-agnostic; extension migration should not break API.

## Install
```bash
npm i @rto/sdk
# or
pnpm add @rto/sdk
```

## Usage
```ts
import { createRtoClient } from "@rto/sdk";

const rto = createRtoClient({ timeoutMs: 15000 });
await rto.detect(); // throws if not detected by default

await rto.open({ url: "https://www.google.com/", tabKey: "google", focus: true, newTab: true, singleton: true });
await rto.domType({ tabKey: "google", selector: 'input[name="q"]', text: "Remote Tab Opener", focus: true, replace: true });
const html = await rto.getHtml({ tabKey: "google", selector: "#search .tF2Cxc", property: "outerHTML" });
console.log(html);

const off = rto.onTabStatus(push => console.log(push));
```

### Browser (no bundler)
```html
<script src="https://cdn.jsdelivr.net/npm/@rto/sdk/dist/index.iife.js"></script>
<script>
const rto = RTO_SDK.createRtoClient({ timeoutMs: 15000 });
</script>
```

## MV2 / MV3 Compatibility
- The SDK is **agnostic**; it uses `postMessage` and listens to responses. 
- For the extension:
  - MV2 and MV3 should keep the same message contracts.
  - If you restrict host permissions in MV3, document how to add allow-list entries.
  - Content scripts don't run on restricted URLs (e.g., `chrome:`).

## Changelog
See `CHANGELOG.md`.

## License
MIT
