import { z } from 'zod';

export const DetectRequest = z.object({
  origin: z.literal('admin-page'),
  type: z.literal('RTO_REQUEST'),
  action: z.literal('detect'),
  requestId: z.string().optional(),
  args: z.object({ require: z.boolean().optional() }).optional()
});

export const RtoResponse = z.object({
  origin: z.string().optional(),
  type: z.string(),
  requestId: z.string().optional(),
  ok: z.boolean().optional(),
  status: z.enum(['ok','error']).optional(),
  data: z.any().optional(),
  error: z.object({
    code: z.string().optional(),
    message: z.string().optional()
  }).optional()
});

export const GetHtmlRequest = z.object({
  origin: z.literal('admin-page'),
  type: z.literal('command'),
  action: z.literal('getHtml'),
  tabKey: z.string(),
  payload: z.object({
    selector: z.string(),
    property: z.enum(['outerHTML','textContent']).optional()
  }),
  requestId: z.string()
});
