// Lightweight, opt-in telemetry (counts only), caller passes send() fn.
export interface TelemetryFn { (event: string, data?: Record<string, any>): void }
export interface TelemetryOptions {
  enabled?: boolean;
  send: TelemetryFn;
}
export function attachTelemetry(rto: any, opts: TelemetryOptions) {
  if (!opts?.enabled) return () => {};
  const off = rto.onTabStatus((push:any) => {
    opts.send('tabStatus', { isOpen: push.isOpen, tabKey: push.tabKey ? 'set' : 'unset' });
  });
  // Count detect/startup
  opts.send('detect', { t: Date.now() });
  return () => off();
}
